include "shadow1.asp"

; ----------- Global Variables

string RouteFile, CurrentDir, ReportFile, AutoMode, GameName

integer true = -1
integer both
integer again

; -----------------------IMPORTANT-----------------------

define DataDir "d:\assist"  ; change this to the path to your TW Assist files.
                            ; To avoid having to add the path to every file
                            ; used the script first changes to this dir.

; --------------------------------------------------------

define TWAst "twassist"

; ------------ MAIN

proc main
 vidsave 0
 getcur n0 n9
 getdir 0 CurrentDir         ; Stores current directory
 chdir DataDir               ; Switches to the TW Assist directory

 MENU:
  clear
  box 1 22 11 57 64                  ; Edit colors and box size here
  call shadow with 1 22 11 57
  atsay 2 26 79 "<T>W2002 Assistant"
  atsay 3 26 79 "<A>ll reports"
  atsay 4 26 79 "<C>IM sector and port reports"
  atsay 5 26 79 "<P>ort report"
  atsay 6 26 79 "<F>ighters, mines, avoids"
  atsay 7 26 79 "<M>ap universe routes"
  atsay 8 26 79 "<ESC> exit script"
  atsay 10 25 79 "Your selection? : "
  locate 10,46
  keyget n1
  if n1 == 27     ; Looks for the escape key
    call end
  endif
  key2ascii n1 s1
  strupr s1
  clear
  ;
  switch s1
    case "T"
      run TWAst      ; Command that starts TW Assistant. If you want to
      call end       ; auto load a database put "TWASSIST filename"
    case "C"
      both = true
      call openfile
      call CIM
      log close
      call end
    endcase
    case "A"
      both = true
      call openfile
      transmit "v"
      waitfor "Help" 20
      call fighter
      call mines
      call avoids
      call CIM
      log close
      call end
    endcase
    case "F"
      call openfile
      call fighter
      call mines
      call avoids
      log close
      call end
    endcase
    case "P"
      both = false
      call openfile
      call CIM
      log close
      call end
    endcase
    case "M"
      call map
    endcase
    default
      goto MENU
    endcase
  endswitch
endproc

; ------------ END

proc end
   vidrest 0
   locate  n0 n9
   chdir CurrentDir       ; Here it switches back to the original directory
   exit
endproc

;------------- OPENFILE

proc openfile
  string CapFile
  box 1 4 3 25 64
  fatsay 3 10 64 "Q to quit"
  call shadow with 1 4 3 25
  fatsay 2 6 79 "FILE NAME:"
  atget 2 16 79 8 CapFile
  strcmp CapFile "q"
     if success
        call end
     endif
  strcat CapFile ".txt"
  isfile CapFile
     if success
        delete CapFile
     endif

  log open CapFile
endproc

;------------- FIGHTER

proc fighter
  transmit "g"
  waitfor "Help" 15
endproc

;------------- MINES

proc mines
  transmit "k"
  waitfor "? :"
  ;------ Armid scan
  transmit "1"
  waitfor "Help"
  ;------ Limpet scan
  transmit "k"
  waitfor "? :"
  transmit "2"
  waitfor "Help"
endproc

;------------- AVOIDS

proc avoids
  transmit "c"
  waitfor "puter command"
  transmit "x"
  waitfor "puter command"
  transmit "q"
  waitfor "Help"
endproc

;------------- CIM

proc CIM
  transmit "c"
  waitfor "puter command"
  transmit ""
  waitfor ":"
  transmit "^M"            ; this is for twassist v.2.0 because it
  waitfor ":"              ; needs the : on a seperate line due to
  transmit "r"             ; prompt changes in TW2002 v.2.0
  waitfor ":" forever
  transmit "q"
  waitfor "puter command"
  transmit "q"
  waitfor  "Help"
  if both == true              ; Tests for complete CIM report request
      transmit "c"
       waitfor "puter command"
       transmit ""
       waitfor ":"
       transmit "^M"         ; this is for twassist v2.0 because it
       waitfor ":"           ; needs the : on a seperate line.
       transmit "i"
       waitfor ":" forever
    else
       goto SkipSct
    endif
  transmit "q"
  waitfor "puter command"
  transmit "q"
  waitfor  "Help"
SkipSct:
endproc

;------------- MAP

proc map
;  getdir 0 CurrentDir        ; get current directory so it can be restored
;  chdir DataDir              ; change to the TWAssist files directory
   isfile "capture.txt"       ; check for old captuure file
   if success
      delete "capture.txt"    ; delete it if it's there
   endif
   getcur n0 n1
   vidsave 0
   call GetGameName
   call GetRouteFile
   locate n0 n1
   vidrest 0
   again = 1
   while again == 1
      call RunRoutes
      call ShowReport
   endwhile
   chdir CurrentDir
   exit
endproc

;------------ GetGameName

proc GetGameName
   string CmdLine = " /A ME,CAPTURE.TXT, SAVE_DB RM,225 RA,,O"
   box 2 23 5 62 79
   call shadow with 2 23 5 62
   atsay 3 25 79 "Enter game name (enter alone quits)"
   atsay 4 25 79 "> "
   atget 4 28 79 8 GameName
   strcmp GameName ""
   if success
     call end
   endif
   strcat RouteFile GameName
   strcat RouteFile ".cim"
   strcat ReportFile GameName
   strcat ReportFile ".rpt"
   strcat AutoMode "TWASSIST.EXE "
   strcat Automode GameName
   strcat AutoMode CmdLine
endproc

;------------ GetRouteFile


proc GetRouteFile
   log close
   log open "capture.txt"
   transmit "v"
   waitfor "Help" forever
   transmit "c"
   waitfor "puter command"
   transmit "x"
   waitfor "puter command"
   transmit "q"
   waitfor "Help"
   log close
   dos AutoMode             ; shell to DOS, run TWAssist to create routefile
endproc

;------------  RunRoutes    feeds routefile to CIM

proc RunRoutes
   string Line
   isfile RouteFile
      if not success
         errormsg  "Route file not found... exiting script"
         call end
      endif
   fopen 1 RouteFile "r"
   log open "capture.txt"
   transmit "c"
   waitfor "puter command"
   transmit ""
   waitfor ":"
   when 0 "Clear Avoids?" transmit "n"
   while not eof 1
      fgets 1 Line
      transmit Line
      transmit "^M"
      waitfor "To >"
      fgets 1 Line
      transmit Line
      transmit "^M"
      waitfor ":"
   endwhile
   fclose 1
   cwhen 0
   transmit "q"
   waitfor "puter command"
   transmit "q"
   waitfor "Help"
   log close
   dos AutoMode
endproc

;-------------  ShowReport

proc ShowReport
   isfile ReportFile
      if not success
         goto NOPE
      else
         type ReportFile
      endif
   getcur n0 n1
   vidsave 0
   box 2 4 6 40 79
   call shadow with 2 4 6 40
   atsay 4 6 79 "Do another set of routes? (Y/N) "
   locate 4 39
   keyget n9
   key2ascii n9 s1
   strupr s1
   strcmp s1 "Y"
      if not success
         again = 0
      endif
   vidrest 0
   locate n0 n1
NOPE:
endproc



